﻿<?LassoScript
/*
This demo illustrates how to place images on a pdf using coordinates.
Notice that images is placed on the page using the image objects bottom left corner.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype, -nocompress));

// Create some text and put it into a PDF_text object
var('text' = pdf_text( 'If you mix text and images on the same page, text will always float on top of the image even if you add the text first and the image last.\rNote that images are placed using the bottom left corner of the image.'));

// Place the text object without any placement params
$pdf -> add( $text,
	-leading = 16);

// Place the text object using coordinates and within a box.
$pdf -> add( $text,
	-height = 200,
	-width = 300,
	-left = 100,
	-top = 300,
	-leading = 16);


//Place an image that fills the paper
var('image' = pdf_image(
			-file = 'grayA4.gif'));; // Original image 595 X 792 pixels

// Yes, it's weird that we have a -top param to place an objects bottom...
$pdf -> add( $image,
			-left = 0,
			-top = $pageheight
			);
 
//Place image using same coordinates as the text
var('image' = pdf_image(
			-file = 'red.gif'));
$pdf -> add( $image,
			-left = 100,
			-top = 300
			);

//If we truly want to place the image with the same coordinates as the text
// we need to mix the image height into the equation. 
var('image' = pdf_image(
			-file = 'green.gif')); // Original image 100 X 100 pixels

// We can use -height and -width to set the size of the image. Even distort it.
$pdf -> add( $image,
			-height = 100,
			-width = 300,
			-left = 100,
			-top = 300 + 100
			);

var('image' = pdf_image(
			-file = 'ball.gif')); // Original image 400 X 200 pixels.

// This will place an image suited for high-quality printing with a resolution
// close to 300 pixels/inch. Try and change the division to se how different
// resolutions alter the printed quality.
$pdf -> add( $image,
			-height = 400 / 4,
			-width = 200 / 4,
			-left = 400,
			-top = 300 + 100
			);


// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo2.pdf');

?>